* Meng, X, Rosenthal, R and Rubin, D (1992) Comparing Correlated Correlation Coefficients Psychological Bulletin 111 172-175.
* outputs z value and one-tailed p-value: double to get a two-tailed p

set format f10.5.
DATA LIST free
/r12  r13  r23  n. 
BEGIN DATA
.63 -.03 -.19 15
.59 .31 .71 30
.80 .72 .89 26
END DATA. 



*================================.

* /* Meng's Z test for two correlated
* correlations (r12=r13) having
* n observations with one variable in common ( variable 1)
*
* input columns: r12 r13 r23 n
*
* outputted p-values are one-tailed -
* just double to obtain two-tailed */.
*
*=================================.

set mexpand off.
set format f10.5.
define !meng (  !pos !tokens(1)
                    / !pos !tokens(1)
                   /  !pos !tokens(1)
                  /   !pos !tokens(1)).
compute #lct1=0.5*ln((1+!1)/(1-!1)).
compute #lct2=0.5*ln((1+!2)/(1-!2)).
compute #f=(1-!3)/( 2*( 1- ( 0.5*(!1*!1+!2*!2) ) ) ).
compute #h=1+ ( 0.5*(!1*!1+!2*!2) ) / ( 1- (0.5*(!1*!1+!2*!2)) )*(1-#f).
compute z=(#lct1-#lct2)*sqrt((!4-3)/(2*(1-!3)*#h)).
if (z le 0) prob_z=cdfnorm(z).
if (z gt 0) prob_z=1-cdfnorm(z).

FORMAT !1 !2 z prob_z (f9.3).
VARIABLE LABELS !1 'correlation 1' !2 'correlation 2' /z 'z-value' 
/prob_z  '1-tailed p-value'.
EXECUTE.

REPORT FORMAT=LIST AUTOMATIC ALIGN(CENTER)
  /VARIABLES=!1 !2 z prob_z 
  /TITLE "Meng test of two correlations with one variable in common from same sample".

!enddefine.

set mexpand on.
!meng r12 r13 r23 n.
